"use client"

import {
  ChevronsUpDown,
} from "lucide-react"

import {
  Avatar,
  AvatarFallback,
  AvatarImage,
} from "@/components/ui/avatar"
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuLabel,
  DropdownMenuSeparator,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu"
import {
  SidebarMenuButton,
  useSidebar,
} from "@/components/ui/sidebar"
import { LogoutDropdownMenuItem } from "./logout.dropdown-menu-item"

function INTERNAL__extractFallbackLetter(name: string) {
  if (name.length < 2) {
    return "??"
  }

  const split = name.split(' ')
  if (split.length < 2) {
    return name[0] + name[1]
  }

  return split[0][0] + split[1][0]
}

export function ApplicationUser({
  user,
}: {
  user: {
    name: string,
  }
}) {
  const { isMobile } = useSidebar()

  const alias = (
    <>
      <Avatar className="size-8">
        <AvatarImage src={""} alt={user.name} />
        <AvatarFallback>{INTERNAL__extractFallbackLetter(user.name)}</AvatarFallback>
      </Avatar>
      <div className="grid flex-1 text-left text-sm leading-tight">
        <span className="truncate font-semibold">{user.name}</span>
        {/* <span className="truncate text-xs">{}</span> */}
      </div>
    </>
  )

  return (
    <DropdownMenu>
      <DropdownMenuTrigger asChild>
        <SidebarMenuButton
          size="lg"
          className="data-[state=open]:bg-sidebar-accent data-[state=open]:text-sidebar-accent-foreground"
        >
          {alias}

          <ChevronsUpDown className="ml-auto size-4" />
        </SidebarMenuButton>
      </DropdownMenuTrigger>
      <DropdownMenuContent
        className="w-[--radix-dropdown-menu-trigger-width] min-w-56 rounded-lg"
        side={isMobile ? "bottom" : "right"}
        align="end"
        sideOffset={4}
      >
        <DropdownMenuLabel className="p-0 font-normal">
          <div className="flex items-center gap-2 px-1 py-1.5 text-left text-sm">
            {alias}
          </div>
        </DropdownMenuLabel>

        <DropdownMenuSeparator />

        <LogoutDropdownMenuItem />
      </DropdownMenuContent>
    </DropdownMenu>
  )
}
